/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.dto;

import cn.tuia.payment.api.dto.ConfigPageInfoDTO;
import cn.tuia.payment.api.entity.ConfigPageEntity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class ConfigPageDTO
extends ConfigPageEntity {
    private static final Logger log = LoggerFactory.getLogger(ConfigPageDTO.class);
    private static final long serialVersionUID = -8921323265749356212L;
    private Map<String, ConfigPageInfoDTO> configMap = new HashMap<String, ConfigPageInfoDTO>();

    public static ConfigPageDTO build(ConfigPageEntity entity) {
        if (entity == null) {
            return null;
        }
        ConfigPageDTO dto = new ConfigPageDTO();
        BeanUtils.copyProperties((Object)entity, (Object)dto);
        String config = entity.getConfig();
        if (StringUtils.hasText((String)config)) {
            try {
                Map parsedConfigMap = (Map)JSON.parseObject((String)config, (TypeReference)new TypeReference<Map<String, ConfigPageInfoDTO>>(){}, (Feature[])new Feature[0]);
                dto.setConfigMap(parsedConfigMap);
            }
            catch (Exception e) {
                log.error("Failed to parse config JSON: {}", (Object)config, (Object)e);
            }
        }
        return dto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigPageDTO)) {
            return false;
        }
        ConfigPageDTO other = (ConfigPageDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, ConfigPageInfoDTO> this$configMap = this.getConfigMap();
        Map<String, ConfigPageInfoDTO> other$configMap = other.getConfigMap();
        return !(this$configMap == null ? other$configMap != null : !((Object)this$configMap).equals(other$configMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigPageDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, ConfigPageInfoDTO> $configMap = this.getConfigMap();
        result = result * 59 + ($configMap == null ? 43 : ((Object)$configMap).hashCode());
        return result;
    }

    public Map<String, ConfigPageInfoDTO> getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map<String, ConfigPageInfoDTO> configMap) {
        this.configMap = configMap;
    }

    public String toString() {
        return "ConfigPageDTO(configMap=" + this.getConfigMap() + ")";
    }
}

