package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;


/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum BankMerTimePeriodEnums {
    OTHER(0, "未配置"),
    ONE(1, "0-6"),
    TWO(2, "6-12"),
    THREE(3, "12-18"),
    FOUR(4, "18-24"),
    ;
    private final Integer code;
    private final String msg;

    public static final List<Integer> VALID_LIST = Arrays.asList(ONE.getCode(),
            TWO.getCode(),
            THREE.getCode(),
            FOUR.getCode());

    public static boolean isValid(Integer code) {
        return code != null && VALID_LIST.contains(code);
    }

    /**
     * 判断当前时间属于哪个时间段。
     *
     * @return 返回对应的时间段枚举值，如果当前时间不在任何定义的时间段内，则返回 OTHER。
     */
    public static BankMerTimePeriodEnums determineCurrentPeriod() {
        LocalTime now = LocalTime.now();
        int hour = now.getHour();

        // 根据当前时间的小时数判断属于哪个时间段
        if (hour < 6) {
            return BankMerTimePeriodEnums.ONE;
        } else if (hour < 12) {
            return BankMerTimePeriodEnums.TWO;
        } else if (hour < 18) {
            return BankMerTimePeriodEnums.THREE;
        } else {
            return BankMerTimePeriodEnums.FOUR;
        }
    }

    /**
     * 判断当前时间 的下一个时间段
     *
     * @return 返回对应的时间段枚举值，如果当前时间不在任何定义的时间段内，则返回 OTHER。
     */
    public static BankMerTimePeriodEnums determineNextCurrentPeriod() {
        LocalTime now = LocalTime.now();
        int hour = now.getHour();

        // 根据当前时间的小时数判断属于哪个时间段
        if (hour < 6) {
            return BankMerTimePeriodEnums.TWO;
        } else if (hour < 12) {
            return BankMerTimePeriodEnums.THREE;
        } else if (hour < 18) {
            return BankMerTimePeriodEnums.FOUR;
        } else {
            return BankMerTimePeriodEnums.ONE;
        }
    }
}
