/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.enums;

import java.util.Arrays;
import java.util.List;

public enum PaymentChannelEnum {
    LIANDONG(1, "\u8054\u52a8"),
    WECHAT_MINI(2, "\u81ea\u7814\u5fae\u4fe1\u5c0f\u7a0b\u5e8f"),
    FU_BEI(3, "\u4ed8\u5457"),
    UNION_PAY(4, "\u94f6\u8054"),
    CHENGSHI(5, "\u6a59\u91ca"),
    SAND(6, "\u6749\u5fb7");

    public static final List<PaymentChannelEnum> bankMerList;
    private final Integer code;
    private final String name;

    public static String convert2Name(Integer code) {
        for (PaymentChannelEnum paymentChannelEnum : PaymentChannelEnum.values()) {
            if (!paymentChannelEnum.getCode().equals(code)) continue;
            return paymentChannelEnum.getName();
        }
        return "";
    }

    public static PaymentChannelEnum fromCode(Integer channel) {
        for (PaymentChannelEnum value : PaymentChannelEnum.values()) {
            if (!value.getCode().equals(channel)) continue;
            return value;
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    private PaymentChannelEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    static {
        bankMerList = Arrays.asList(LIANDONG, UNION_PAY);
    }
}

