/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.enums;

import cn.tuia.payment.api.enums.TransStateEnum;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public enum RefundStatusEnum {
    REFUND_INITIAL(1, "", "\u9000\u6b3e\u5355\u521d\u59cb\u5316", "", "", "", ""),
    REFUND_IN_DB_WX(58, "", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u9000\u6b3e\u5165\u5e93\u4e86", "", "", "", ""),
    REFUND_IN_DB(59, "", "\u9000\u6b3e\u5165\u5e93\u4e86", "", TransStateEnum.INI.getCode(), "\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u5ba2\u670d\u8fdb\u884c\u9000\u6b3e", ""),
    REFUND_SUCCESS(60, "REFUND_SUCCESS", "\u9000\u8d39\u6210\u529f", "SUCCESS", TransStateEnum.SUCCESS.getCode(), "REFUND_SUCCESS", "\u63d0\u4ea4\u6210\u529f\uff01\u9000\u6b3e\u5c06\u572810\u5206\u949f\u4e4b\u5185\u539f\u8def\u8fd4\u56de\uff0c\u8bf7\u5173\u6ce8\u8d26\u6237\u4f59\u989d"),
    REFUND_FAIL(70, "REFUND_FAIL", "\u60a8\u7684\u8ba2\u5355\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u5ba2\u670d\u8fdb\u884c\u9000\u6b3e", "FAIL", TransStateEnum.FAILED.getCode(), "REFUND_FAILED", "\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u5ba2\u670d\u8fdb\u884c\u9000\u6b3e"),
    REFUND_WILL_BE_PROCESS_TILL_1230(79, "", "\u60a8\u7684\u9000\u6b3e\u8ba2\u5355\u5df2\u63d0\u4ea4\uff0c\u8bf7\u5173\u6ce8\u8d26\u6237\u4f59\u989d", "", "", "", "\u63d0\u4ea4\u6210\u529f\uff01\u9000\u6b3e\u5c06\u572810\u5206\u949f\u4e4b\u5185\u539f\u8def\u8fd4\u56de\uff0c\u8bf7\u5173\u6ce8\u8d26\u6237\u4f59\u989d"),
    REFUND_PROCESS(80, "REFUND_PROCESSING", "\u9000\u8d39\u5904\u7406\u4e2d", "PROCESSING", TransStateEnum.ING.getCode(), "", "\u63d0\u4ea4\u6210\u529f\uff01\u9000\u6b3e\u5c06\u572810\u5206\u949f\u4e4b\u5185\u539f\u8def\u8fd4\u56de\uff0c\u8bf7\u5173\u6ce8\u8d26\u6237\u4f59\u989d"),
    REFUND_UNKNOWN(90, "", "\u9000\u8d39\u7ed3\u679c\u4e0d\u660e", "UNKNOWN", "", "", "\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u5ba2\u670d\u8fdb\u884c\u9000\u6b3e"),
    REFUND_WAIT_AUDIT(100, "", "\u7b49\u5f85\u4eba\u5de5\u5ba1\u6838", "", "", "", "\u63d0\u4ea4\u6210\u529f\uff01\u9000\u6b3e\u5c06\u572810\u5206\u949f\u4e4b\u5185\u539f\u8def\u8fd4\u56de\uff0c\u8bf7\u5173\u6ce8\u8d26\u6237\u4f59\u989d"),
    MER_PROCESS(110, "", "\u60a8\u7684\u8ba2\u5355\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u4eba\u5de5\u5ba2\u670d\u8fdb\u884c\u9000\u6b3e", "", "", "", "\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u5ba2\u670d\u8fdb\u884c\u9000\u6b3e");

    private final Integer code;
    private final String fubeiCode;
    private final String msg;
    private final String unionPayCode;
    private final String chengshiPayCode;
    private final String sandPayCode;
    private final String desc;
    public static final List<Integer> canRefundStatusList;
    public static final List<Integer> successRefundStatus;
    public static final List<Integer> processRefundStatus;
    public static final List<Integer> refundWarnStatus;

    public static void main(String[] args) {
        System.out.println(RefundStatusEnum.sand2Code(null));
    }

    public static String getDescByCode(Integer code) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return value.getDesc();
        }
        return null;
    }

    public static String getMsg(Integer code) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (!Objects.equals(value.getCode(), code)) continue;
            return value.getMsg();
        }
        return null;
    }

    public static RefundStatusEnum getMsgByCode(Integer code) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (!Objects.equals(value.getCode(), code)) continue;
            return value;
        }
        return REFUND_PROCESS;
    }

    public static boolean canRefund(Integer status) {
        return Objects.nonNull(status) && (REFUND_INITIAL.getCode().equals(status) || RefundStatusEnum.fail(status));
    }

    public static boolean fail(Integer status) {
        return Objects.equals(REFUND_UNKNOWN.getCode(), status) || Objects.equals(MER_PROCESS.getCode(), status) || Objects.equals(REFUND_FAIL.getCode(), status);
    }

    public static Integer sand2Code(String status) {
        if (Strings.isNullOrEmpty((String)status)) {
            return MER_PROCESS.getCode();
        }
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (!value.getSandPayCode().equalsIgnoreCase(status)) continue;
            return value.getCode();
        }
        return MER_PROCESS.getCode();
    }

    public static Integer chenshi2Code(String status) {
        if (Strings.isNullOrEmpty((String)status)) {
            return MER_PROCESS.getCode();
        }
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (!value.getChengshiPayCode().equalsIgnoreCase(status)) continue;
            return value.getCode();
        }
        return MER_PROCESS.getCode();
    }

    public static Integer unionPay2Code(String status) {
        if (Strings.isNullOrEmpty((String)status)) {
            return MER_PROCESS.getCode();
        }
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (!value.getUnionPayCode().equalsIgnoreCase(status)) continue;
            return value.getCode();
        }
        return MER_PROCESS.getCode();
    }

    public static Integer liandongTrans2code(String status) {
        if (Strings.isNullOrEmpty((String)status)) {
            return MER_PROCESS.getCode();
        }
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (!value.name().equalsIgnoreCase(status)) continue;
            return value.getCode();
        }
        return MER_PROCESS.getCode();
    }

    public static Integer fubeiTrans2code(String status) {
        if (Strings.isNullOrEmpty((String)status)) {
            return MER_PROCESS.getCode();
        }
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (!value.getFubeiCode().equalsIgnoreCase(status)) continue;
            return value.getCode();
        }
        return MER_PROCESS.getCode();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getFubeiCode() {
        return this.fubeiCode;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getUnionPayCode() {
        return this.unionPayCode;
    }

    public String getChengshiPayCode() {
        return this.chengshiPayCode;
    }

    public String getSandPayCode() {
        return this.sandPayCode;
    }

    public String getDesc() {
        return this.desc;
    }

    private RefundStatusEnum(Integer code, String fubeiCode, String msg, String unionPayCode, String chengshiPayCode, String sandPayCode, String desc) {
        this.code = code;
        this.fubeiCode = fubeiCode;
        this.msg = msg;
        this.unionPayCode = unionPayCode;
        this.chengshiPayCode = chengshiPayCode;
        this.sandPayCode = sandPayCode;
        this.desc = desc;
    }

    static {
        canRefundStatusList = Arrays.asList(REFUND_IN_DB.getCode(), REFUND_FAIL.getCode(), REFUND_UNKNOWN.getCode(), MER_PROCESS.getCode());
        successRefundStatus = Arrays.asList(REFUND_SUCCESS.getCode());
        processRefundStatus = Arrays.asList(REFUND_PROCESS.getCode(), REFUND_WAIT_AUDIT.getCode());
        refundWarnStatus = Arrays.asList(REFUND_IN_DB.getCode(), REFUND_FAIL.getCode(), REFUND_UNKNOWN.getCode(), MER_PROCESS.getCode());
    }
}

