package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: ConfigPageEntity
 * @projectName tuia-payment
 * @description: Configuration page entity
 * @date 2024.09.23
 */
@Getter
@Setter
@TableName("tb_config_page")
public class ConfigPageEntity implements Serializable {
    private static final long serialVersionUID = 3508601968591901526L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 积木id
     */
    @TableField("jimu_id")
    private String jimuId;

    /**
     * 行业
     */
    @TableField("industry")
    private Integer industry;

    /**
     * 创建人
     */
    @TableField("creator")
    private String creator;

    /**
     * 最后编辑人
     */
    @TableField("last_admin_id")
    private String lastAdminId;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 配置信息
     */
    @TableField("config")
    private String config;
}
