package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum PaymentChannelEnum {
    LIANDONG(1, "联动"),
    WECHAT_MINI(2, "自研微信小程序"),
    FU_BEI(3, "付呗"),
    UNION_PAY(4, "银联"),
    CHENGSHI(5, "橙释"),
    SAND(6, "杉德"),
    ALI_PAY(7, "推啊支付宝"),
    ;

    public static final List<PaymentChannelEnum> bankMerList = Arrays.asList(LIANDONG, UNION_PAY);

    public static String convert2Name(Integer code) {
        for (PaymentChannelEnum paymentChannelEnum : PaymentChannelEnum.values()) {
            if (paymentChannelEnum.getCode().equals(code)) {
                return paymentChannelEnum.getName();
            }
        }
        return "";
    }

    private final Integer code;
    private final String name;

    public static PaymentChannelEnum fromCode(Integer channel) {
        for (PaymentChannelEnum value : PaymentChannelEnum.values()) {
            if (value.getCode().equals(channel)) {
                return value;
            }
        }
        return null;
    }
}
