package cn.tuia.payment.api.dto.query;

import cn.tuia.payment.api.entity.MerchantEntity;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * @author y.zhao
 * @title: MerchantInQuery
 * @projectName tuia-payment-center
 * @description: description
 * 内部查询条件
 * @date 2024.10.11 15:58
 */
@Data
@Builder
public class MerchantInQuery implements Serializable {
    private static final long serialVersionUID = -8496757981448431423L;

    private Integer channel;

    private String type;

    private Integer releasingStatus;

    private Integer timePeriod;

    private Integer onOff;

    private Long poolId;

    private Integer limit;

    // 修改为 SFunction，用于支持传递方法引用
    private SFunction<MerchantEntity, ?> orderBy;

    // 指定是否升序排序，true 为升序，false 为降序
    private Boolean isAsc;
}
