package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
@TableName("tb_bank_mer_batch_update_task")
public class BankMerBatchUpdateTaskEntity implements Serializable {

    private static final long serialVersionUID = 3067311199428560847L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * excel文件名
     */
    @TableField("file_name")
    private String fileName;

    /**
     * 上传人ID
     */
    @TableField("admin_id")
    private String adminId;

    /**
     * 上传人姓名
     */
    @TableField("admin_name")
    private String adminName;

    /**
     * 任务处理状态
     */
    @TableField("task_status")
    private Integer taskStatus;

    /**
     * 结果文件下载地址
     */
    @TableField("result_url")
    private String resultUrl;

    /**
     * excel总行数
     */
    @TableField("total_row_num")
    private Integer totalRowNum;

    /**
     * paymentChannel
     */
    @TableField("payment_channel")
    private Integer paymentChannel;

    /**
     * paymentChannel
     */
    @TableField("operation")
    private String operation;
}