package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author lizhiheng
 */

@Getter
@AllArgsConstructor
public enum LiandongMerchantEnum {

    MER_55502("55502", "爆靓", "key/55502_.key.p8", "/root/keys/55502_.key.p8", "20240703222214U8K"),
    MER_55581("55581", "青岛集量", "key/55581_.key.p8", "/root/keys/55581_.key.p8", "20240705174913UBP"),

    ;

    private final String code;
    private final String msg;
    private final String resourcePath;
    private final String path;
    private final String groupId;

    public static LiandongMerchantEnum getCodeByMerId(String merId) {
        // 兜底55502
        return Arrays.stream(LiandongMerchantEnum.values()).filter(one -> one.getCode().equals(merId)).findFirst().orElse(MER_55502);
    }

    public static boolean isValid(String merId) {
        for (LiandongMerchantEnum value : LiandongMerchantEnum.values()) {
            if (value.getCode().equals(merId)) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(LiandongMerchantEnum.getCodeByMerId("55502"));
    }
}