package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.PayOrderV2InfoDTO;
import cn.tuia.payment.api.dto.RefundOrderReportDTO;
import cn.tuia.payment.api.dto.req.PayOrderV2InfoReq;
import cn.tuia.payment.api.dto.req.RefundOrderReportReq;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.PayOrderV2InfoEntity;

import java.util.List;

/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemotePayOrderV2InfoService {

    ResultPage<PayOrderV2InfoDTO> page(ReqPageQuery<PayOrderV2InfoReq> req);

    List<PayOrderV2InfoDTO> list(PayOrderV2InfoReq req);

    boolean save(PayOrderV2InfoEntity entity);

    boolean saveOrNothing(PayOrderV2InfoEntity entity);

    PayOrderV2InfoEntity getByOrderId(String orderId);

    boolean updateByOrderId(PayOrderV2InfoEntity entity);

    /**
     * 根据支付渠道 统计 今日退款成功率通知：
     * <p>
     * 渠道、今日发起退款量、今日退款成功量、今日退款中量、今日退款失败量、今日退款成功率（备注：发起退款时间=今天）
     *
     * @param req
     * @return
     */
    RefundOrderReportDTO refundStatisticsByChannel(RefundOrderReportReq req);
}
