package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author y.zhao
 * @title: OrderRefundStatusEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.09.23 16:48
 */
@Getter
@AllArgsConstructor
public enum OrderRefundStatusEnum {

    DEFAULT(0, "初始值"),

    REFUND_ING(10, "退款中"),

    REFUND_FAILED(20, "退款失败"),

    REFUND_PART_SUCCESS(30, "部分退款成功"),

    REFUND_SUCCESS(40, "退款成功"),
    ;

    private final Integer code;
    private final String desc;

    public static final List<Integer> successList = Arrays.asList(REFUND_PART_SUCCESS.code, REFUND_SUCCESS.getCode());

    public static final List<Integer> failedList = Arrays.asList(REFUND_FAILED.code);
}
