package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.MerchantDTO;
import cn.tuia.payment.api.dto.req.MerchantQuery;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.MerchantEntity;
import cn.tuia.payment.api.entity.UpBankMerEntity;

import java.util.List;

/**
 * @author y.zhao
 * @title: RemoteMerchantService
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.10.09 16:26
 */
@AdvancedFeignClient
public interface RemoteMerchantService {

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    ResultPage<MerchantDTO> page(ReqPageQuery<MerchantQuery> query);

    /**
     * 列表
     *
     * @param query
     * @return
     */
    List<MerchantDTO> list(MerchantQuery query);

    /**
     * 更新/写入
     *
     * @param merchantEntity
     * @return
     */
    boolean upsert(MerchantEntity merchantEntity);

    /**
     * 根据主键获取
     *
     * @param id
     * @return
     */
    MerchantDTO getById(Long id);
}
