package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: ActOrderTransferEntity
 * @projectName tuia-payment
 * @description: description
 * @date 2024.07.02 15:17
 */
@Getter
@Setter
@TableName("tb_act_order_transfer")
public class ActOrderTransferEntity implements Serializable {

    private static final long serialVersionUID = -2727977279017136297L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 更新时间
     */
    @TableField("gmt_modified")
    private Date gmtModified;

    /**
     * 关联订单号
     */
    @TableField("order_no")
    private String orderNo;

    /**
     * 子业务单号
     */
    @TableField("biz_order_no")
    private String bizOrderNo;

    /**
     * 渠道
     */
    @TableField("channel")
    private Integer channel;

    /**
     * 付款方账号
     */
    @TableField("payer")
    private String payer;

    /**
     * 收款方账号
     */
    @TableField("payee")
    private String payee;

    /**
     * 收款方姓名
     */
    @TableField("payee_name")
    private String payeeName;

    /**
     * 原转账金额
     */
    @TableField("original_amount")
    private Long originalAmount;

    /**
     * 实际转账金额
     */
    @TableField("amount")
    private Long amount;

    /**
     * 转账单号
     */
    @TableField("transfer_order_no")
    private String transferOrderNo;

    /**
     * 转账时间
     */
    @TableField("transfer_time")
    private Date transferTime;

    /**
     * 转账状态
     */
    @TableField("transfer_status")
    private Integer transferStatus;

    /**
     * 扩展字段
     */
    @TableField("extra")
    private String extra;

    /**
     * jimuId
     */
    @TableField("jimu_id")
    private String jimuId;

    /**
     * ip
     */
    @TableField("ip")
    private String ip;
}

