package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: MerTimeConfigEntity
 * @projectName tuia-payment-center
 * @description: 商户号时段配置实体类
 * @date 2024.08.20 14:15
 */
@Data
@TableName("tb_mer_time_config")
public class MerTimeConfigEntity implements Serializable {


    private static final long serialVersionUID = -6295155411648703878L;
    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 支付渠道
     */
    @TableField("channel")
    private Integer channel;

    /**
     * 分组
     */
    @TableField("tab_code")
    private String tabCode;

    /**
     * 时段
     */
    @TableField("time_period")
    private Integer timePeriod;

    /**
     * 开始时间点
     */
    @TableField("start_time")
    private Integer startTime;

    /**
     * 结束时间点
     */
    @TableField("end_time")
    private Integer endTime;

    /**
     * 在投阈值
     */
    @TableField("releasing_num")
    private Integer releasingNum;

    /**
     * 待投阈值
     */
    @TableField("re_release_num")
    private Integer reReleaseNum;
}
