package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.MerchantDTO;
import cn.tuia.payment.api.dto.req.MerchantQuery;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.MerchantEntity;

import java.util.List;
import java.util.Set;

/**
 * @author y.zhao
 * @title: RemoteMerchantService
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.10.09 16:26
 */
@AdvancedFeignClient
public interface RemoteMerchantService {

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    ResultPage<MerchantDTO> page(ReqPageQuery<MerchantQuery> query);

    /**
     * 列表
     *
     * @param query
     * @return
     */
    List<MerchantDTO> list(MerchantQuery query);

    /**
     * 获取一个商户号
     * 只返回主表数据
     */
    MerchantEntity one(MerchantQuery query);

    /**
     * 更新/写入
     *
     * @param merchantEntity
     * @return
     */
    boolean upsert(MerchantEntity merchantEntity);

    /**
     * 根据主键获取
     *
     * @param id
     * @return
     */
    MerchantDTO getById(Long id);

    /**
     * 从缓存池中获取 子商户号
     *
     * @param channel
     * @param type
     * @param timePeriod
     * @param poolId
     * @return
     */
    Set<String> membersFromThePool(Integer channel, String type, Integer timePeriod, Long poolId);
}
