package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.ReplenishOrderDTO;
import cn.tuia.payment.api.dto.ReplenishStatisticDTO;
import cn.tuia.payment.api.dto.req.ReplenishOrderQuery;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.ReplenishOrderEntity;

import java.util.List;

/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemoteReplenishOrderService {


    boolean save(ReplenishOrderEntity entity);

    boolean bindOrderId(ReplenishOrderEntity entity);

    boolean unlock(Long primaryKey);

    @Deprecated
    ReplenishOrderEntity chooseOneReplenishOrder(Integer channel, Integer howManyHoursBefore);

    ReplenishOrderEntity chooseOneReplenishOrder(Integer channel,String cityCode, Integer howManyDaysBefore);

    ResultPage<ReplenishOrderDTO> page(ReqPageQuery<ReplenishOrderQuery> query);

    List<ReplenishStatisticDTO> statistic();
}
