package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: ChannelOrderRecordEntity
 * @projectName tuia-payment-center
 * @description: 渠道推送订单记录表
 * @date 2024.10.09 16:13
 */
@Data
@TableName("tb_channel_order_record")
public class ChannelOrderRecordEntity implements Serializable {

    private static final long serialVersionUID = 8350616132053278428L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * tuiaiId
     */
    @TableField("tuia_id")
    private String tuiaId;

    /**
     * 渠道
     *
     * @see cn.tuia.payment.api.enums.PaymentChannelEnum
     */
    @TableField("channel")
    private Integer channel;

    /**
     * 关联内部订单id（退款时为退款单id）
     */
    @TableField("order_id")
    private String orderId;

    /**
     * 类型 1-交易成功 2-退款
     *
     * @see cn.tuia.payment.api.enums.ChannelOrderRecordTypeEnum
     */
    @TableField("type")
    private Integer type;

    /**
     * 扩展字段
     */
    @TableField("extra")
    private String extra;

}