package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: MerchantEntity
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.10.09 16:13
 */
@Data
@TableName("tb_merchant")
public class MerchantEntity implements Serializable {

    private static final long serialVersionUID = 8350616132053278428L;
    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 渠道
     */
    @TableField("channel")
    private Integer channel;

    /**
     * 类型
     */
    @TableField("type")
    private String type;

    /**
     * 分组
     */
    @TableField("mer_group")
    private String merGroup;

    /**
     * 子商户号
     */
    @TableField("bank_mer_id")
    private String bankMerId;

    /**
     * 时段
     */
    @TableField("time_period")
    private Integer timePeriod;

    /**
     * 渠道状态
     */
    @TableField("channel_status")
    private Integer channelStatus;

    /**
     * 推啊状态
     */
    @TableField("tuia_status")
    private Integer tuiaStatus;

    /**
     * 投放状态
     */
    @TableField("release_status")
    private Integer releaseStatus;

    /**
     * 投放状态修改时间
     */
    @TableField("release_modified_time")
    private Date releaseModifiedTime;

    /**
     * 待投开关
     */
    @TableField("on_off")
    private Integer onOff;

    /**
     * 待投开始时间
     */
    @TableField("on_time")
    private Date onTime;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 主体
     */
    @TableField("main_body")
    private String mainBody;

    /**
     * 商户池id
     */
    @TableField("pool_id")
    private Long poolId;

    /**
     * 投放开始时间
     */
    @TableField("gmt_releasing")
    private Date gmtReleasing;

    /**
     * 最后编辑人
     */
    @TableField("last_admin_id")
    private String lastAdminId;

    /**
     * 最后编辑时间
     */
    @TableField("last_edit_time")
    private Date lastEditTime;


    /**
     * 账户ID
     */
    @TableField("auth_id")
    private Long authId;

    /**
     * ip地址的行政编码，如：1101，只有4位
     */
    @TableField("ip_geo_code")
    private String ipGeoCode;


    /**
     * 扩展字段
     */
    @TableField("extra")
    private String extra;
}
