package cn.tuia.payment.api.enums;

import com.google.common.base.Strings;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author y.zhao
 * @title: MerchantPayWayEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.11.29 15:43
 */
@Getter
@AllArgsConstructor
public enum MerchantPayWayEnum {
    ALI_PAY(1, "支付宝"),
    WECHAT_PAY(2, "微信"),
    SHOP(3, "淘宝店铺"),
    ;

    private final Integer code;
    private final String desc;

    public static Integer convert2Code(String name) {
        if (Strings.isNullOrEmpty(name)) {
            return null;
        }
        for (MerchantPayWayEnum value : MerchantPayWayEnum.values()) {
            if (Objects.equals(name, value.getDesc())) {
                return value.getCode();
            }
        }
        return null;
    }

    public static String convert2Name(Integer code){
        if (Objects.isNull(code)) {
            return null;
        }
        for (MerchantPayWayEnum value : MerchantPayWayEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value.getDesc();
            }
        }
        return null;
    }
}
