package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.req.LimitConfigDTO;
import cn.tuia.payment.api.dto.req.LimitConfigQuery;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.LimitConfigEntity;

import java.util.List;

/**
 * @author y.zhao
 * @title: RemoteMerchantUnionPayService
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.07.23 18:15
 */
@AdvancedFeignClient
public interface RemoteLimitConfigService {

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    ResultPage<LimitConfigEntity> page(ReqPageQuery<LimitConfigQuery> query);

    /**
     * 列表
     *
     * @param query
     * @return
     */
    List<LimitConfigEntity> list(LimitConfigQuery query);

    /**
     * 获取一个商户号
     * 只返回主表数据
     */
    LimitConfigEntity one(LimitConfigQuery query);

    /**
     * 获取主体列表
     */
    List<String> getMainBodyList();

    /**
     * 更新/插入
     */
    boolean upsert(LimitConfigDTO upsert);

    /**
     * 删除
     */
    boolean delete(LimitConfigDTO upsert);

    boolean doLimit(Integer paymentChannel, String merIdOrIndustry, String bankMerId, Long payAmount);
}
