package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.entity.RefundOrderEntity;

import java.util.List;

/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemoteRefundOrderService {

    Long save(RefundOrderEntity refundOrderEntity);

    boolean updateByMultiId(RefundOrderEntity refundOrderEntity);

    boolean updateByRefundNo(RefundOrderEntity refundOrderEntity);

    List<RefundOrderEntity> selectAllMiddleNightRefundOrder();

    List<RefundOrderEntity> selectNotRefundYetOrder();

    RefundOrderEntity getByRefundNo(String refundNo);

    List<RefundOrderEntity> getByOrderId(String orderId);

    List<RefundOrderEntity> getByBankOrderId(String bankOrderId);

    RefundOrderEntity getOneByBankOrderId(String bankOrderId);

    RefundOrderEntity getSuccessOneByBankOrderId(String bankOrderId);

    /**
     * 查询上个月今天退款单
     */
    List<RefundOrderEntity> getTheSameDayLastMonthData();

    /**
     * 查询 最近 hours 个小时内失败的退款单
     *
     * @return
     */
    List<RefundOrderEntity> getFailedOrder4Hours(Integer hours);
}
