package cn.tuia.payment.api.dto;

import cn.tuia.payment.api.entity.BankMerPoolEntity;
import cn.tuia.payment.api.entity.MerchantEntity;
import cn.tuia.payment.api.enums.PaymentChannelEnum;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

/**
 * @author y.zhao
 * @title: MerchantDataDTO
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.10.11 16:24
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantDataDTO extends MerchantEntity {
    private static final long serialVersionUID = 3477781132667632032L;


    /**
     * 预拉起次数
     */
    private Integer prepayTimes;


    public static MerchantDataDTO toDTO(MerchantEntity entity, Map<String, Integer> bankMerIdToPrepayTimesMap) {
        MerchantDataDTO dto = new MerchantDataDTO();
        BeanUtils.copyProperties(entity, dto);
        dto.setPrepayTimes(Objects.isNull(bankMerIdToPrepayTimesMap) ? 0 : bankMerIdToPrepayTimesMap.get(entity.getBankMerId()));
        return dto;
    }
}
