/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public enum BankMerStatusEnums {
    NOT_AVAILABLE(-1, "\u4e0d\u53ef\u7528"),
    OFF(0, "\u5173\u95ed"),
    ON(1, "\u542f\u7528"),
    BANNED(2, "\u7981\u7528");

    private final Integer code;
    private final String name;
    public static final List<Integer> AVAILABLE_LIST;
    public static final List<Integer> NOT_AVAILABLE_LIST;
    public static final List<Integer> VALID_LIST;

    public static boolean isValid(Integer code) {
        return Objects.nonNull(code) && VALID_LIST.contains(code);
    }

    public static String trans2name(Integer code) {
        BankMerStatusEnums[] values;
        for (BankMerStatusEnums one : values = BankMerStatusEnums.values()) {
            if (!one.getCode().equals(code)) continue;
            return one.getName();
        }
        return "";
    }

    public static Integer trans2Code(String name) {
        BankMerStatusEnums[] values;
        for (BankMerStatusEnums one : values = BankMerStatusEnums.values()) {
            if (!one.getName().equals(name)) continue;
            return one.getCode();
        }
        return null;
    }

    public static boolean notAvailable(Integer code) {
        return NOT_AVAILABLE_LIST.contains(code);
    }

    public static boolean available(Integer code) {
        return AVAILABLE_LIST.contains(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    private BankMerStatusEnums(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    static {
        AVAILABLE_LIST = Arrays.asList(ON.getCode());
        NOT_AVAILABLE_LIST = Arrays.asList(NOT_AVAILABLE.getCode(), OFF.getCode(), BANNED.getCode());
        VALID_LIST = Arrays.asList(NOT_AVAILABLE.getCode(), OFF.getCode(), ON.getCode(), BANNED.getCode());
    }
}

