/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum PaymentChannelEnum {
    LIANDONG(1, "\u8054\u52a8"),
    WECHAT_MINI(2, "\u81ea\u7814\u5fae\u4fe1\u5c0f\u7a0b\u5e8f"),
    FU_BEI(3, "\u4ed8\u5457"),
    UNION_PAY(4, "\u94f6\u8054"),
    CHENGSHI(5, "\u6a59\u91ca"),
    SAND(6, "\u6749\u5fb7"),
    ALI_PAY(7, "\u63a8\u554a\u652f\u4ed8\u5b9d"),
    LIANDONG_V2(8, "\u8054\u52a8\u65b0"),
    SHOP(9, "\u5e97\u94fa"),
    UNION_PAY_SC(10, "\u56db\u5ddd\u94f6\u8054"),
    SHANGMENG(11, "\u5546\u76df"),
    GUOGUANG(12, "\u56fd\u5e7f"),
    HUIFU(13, "\u6c47\u4ed8"),
    ZHIFUTONG(15, "\u76f4\u4ed8\u901a"),
    LESHUA(16, "\u4e50\u5237");

    public static final List<PaymentChannelEnum> bankMerList;
    public static final List<Integer> bankMerCodeList;
    private final Integer code;
    private final String name;

    public static String convert2Name(Integer code) {
        for (PaymentChannelEnum paymentChannelEnum : PaymentChannelEnum.values()) {
            if (!paymentChannelEnum.getCode().equals(code)) continue;
            return paymentChannelEnum.getName();
        }
        return "";
    }

    public static PaymentChannelEnum fromCode(Integer channel) {
        for (PaymentChannelEnum value : PaymentChannelEnum.values()) {
            if (!value.getCode().equals(channel)) continue;
            return value;
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    private PaymentChannelEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    static {
        bankMerList = Arrays.asList(LIANDONG, UNION_PAY, CHENGSHI, ALI_PAY, LIANDONG_V2, SHOP, UNION_PAY_SC, SHANGMENG, GUOGUANG, HUIFU, ZHIFUTONG, LESHUA);
        bankMerCodeList = bankMerList.stream().map(PaymentChannelEnum::getCode).collect(Collectors.toList());
    }
}

