package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: ActOrderPayEntity
 * @projectName tuia-payment
 * @description: description
 * @date 2024.07.02 15:16
 */
@Getter
@Setter
@TableName("tb_act_order_pay")
public class ActOrderPayEntity implements Serializable {

    private static final long serialVersionUID = -6523985765789808826L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 关联订单号
     */
    @TableField("order_no")
    private String orderNo;

    /**
     * 支付渠道
     */
    @TableField("channel")
    private Integer channel;

    /**
     * 商户号
     */
    @TableField("merchant_id")
    private String merchantId;

    /**
     * 子商户号
     */
    @TableField("sub_merchant_id")
    private String subMerchantId;

    /**
     * 原支付金额
     */
    @TableField("original_amount")
    private Long originalAmount;

    /**
     * 实际支付金额
     */
    @TableField("amount")
    private Long amount;

    /**
     * 支付方式
     */
    @TableField("pay_way")
    private Integer payWay;

    /**
     * 支付订单号
     */
    @TableField("pay_order_no")
    private String payOrderNo;

    /**
     * 支付时间
     */
    @TableField("pay_time")
    private Date payTime;

    /**
     * 支付状态
     * @see cn.tuia.payment.params.enums.PayStatusEnum
     */
    @TableField("pay_status")
    private Integer payStatus;

    /**
     * 支付唤起时间
     */
    @TableField("open_time")
    private Date openTime;

    /**
     * 支付链接
     */
    @TableField("pay_url")
    private String payUrl;

    /**
     * appId
     */
    @TableField("app_id")
    private String appId;

    /**
     * appPath
     */
    @TableField("app_path")
    private String appPath;

    /**
     * 扩展字段
     */
    @TableField("extra")
    private String extra;


    /**
     * 业务单号
     */
    @TableField("biz_order_no")
    private String bizOrderNo;
}

