package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 会籍卡积分表
 * @author lizhiheng
 */
@Data
@TableName("tb_member_ship_point")
public class MemberShipPointEntity implements Serializable {

    private static final long serialVersionUID = 3767855158335992008L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;

    /**
     * 我们的订单号（商户订单号）
     */
    @TableField("order_id")
    private String orderId;
    /**
     * tuia_id
     */
    @TableField("tuia_id")
    private String tuiaId;
    /**
     * 操作类型_1是加积分，2是减积分
     */
    @TableField("option_type")
    private Integer optionType;
    /**
     * 积分值
     */
    @TableField("point")
    private Integer point;
    /**
     * 积分过期时间
     */
    @TableField("expire_time")
    private Date expireTime;
    /**
     * 调用积分接口状态，1成功，0失败
     */
    @TableField("remote_status")
    private Integer remoteStatus;

    /**
     * 记录创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;


}
