package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * UnionPay银联子商户主表
 * </p>
 *
 * @since 2024/08/06
 */
@Data
@TableName("tb_up_bank_mer")
public class UpBankMerEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 主商户id，和tb_pay_order表的merchant_no是一个字段
     */
    @TableField("industry")
    private Integer industry;

    /**
     * 子商户id（二级商户id），和tb_pay_order的bank_merchant_no是一个字段
     */
    @TableField("bank_mer_id")
    private String bankMerId;

    /**
     * 分组，联动的分组
     */
    @TableField("terminal_code")
    private String terminalCode;

    /**
     * 使用时段，运营维护，一天分为4个时段，1，2，3，4
     */
    @TableField("time_period")
    private Integer timePeriod;

    /**
     * 银联的状态
     */
    @TableField("up_status")
    private Integer upStatus;

    /**
     * 人工操作的状态，启用、关闭、禁用
     */
    @TableField("tuia_status")
    private Integer tuiaStatus;

    /**
     * 投放状态，待投、在投、下线、未知
     */
    @TableField("release_status")
    private Integer releaseStatus;

    /**
     * 投放状态更新时间
     */
    @TableField("release_modified_time")
    private Date releaseModifiedTime;

    /**
     * 使用时段更新时间
     */
    @TableField("period_modified_time")
    private Date periodModifiedTime;

    /**
     * 最近编辑人
     */
    @TableField("last_admin_id")
    private String lastAdminId;

    /**
     * 终端号
     */
    @TableField("terminal")
    private String terminal;

    /**
     * 主体
     */
    @TableField("main_body")
    private String mainBody;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
}