package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.entity.ActOrderRefundEntity;

import java.util.List;

/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemoteActOrderRefundService {
    /**
     * 根据订单号获取 退款单
     * 目前只会有一条，但是先返回列表，业务层自行分离
     *
     * @param orderNo
     * @return
     */
    List<ActOrderRefundEntity> getByOrderNo(String orderNo);

    /**
     * 查询退款中的订单
     *
     * @return
     */
    List<ActOrderRefundEntity> getRefundIngOrder();


    /**
     * 根据状态查询订单
     *
     * @return
     */
    List<ActOrderRefundEntity> getRefundByStatus(Integer status);

    boolean updateById(ActOrderRefundEntity entity);
    boolean save(ActOrderRefundEntity entity);
}
