package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: ComplainStatusEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.06 14:49
 */
@Getter
@AllArgsConstructor
public enum ComplainStatusEnum {
    /**
     * 用户撤诉
     */
    DROP_COMPLAIN("用户撤诉"),

    /**
     * 超时后用户撤诉
     */
    DROP_OVERDUE_COMPLAIN("超时后用户撤诉"),

    /**
     * 超时处理完成用户撤诉
     */
    DROP_OVERDUE_PROCESSED("超时处理完成用户撤诉"),

    /**
     * 处理完成用户撤诉
     */
    DROP_PROCESSED("处理完成用户撤诉"),

    /**
     * 超时未处理
     */
    OVERDUE("超时未处理"),

    /**
     * 超时处理完成
     */
    OVERDUE_PROCESSED("超时处理完成"),

    /**
     * 部分超时未处理
     */
    PART_OVERDUE("部分超时未处理"),

    /**
     * 处理完成
     */
    PROCESSED("处理完成"),

    /**
     * 处理中
     */
    PROCESSING("处理中"),

    /**
     * 待处理
     */
    WAIT_PROCESS("待处理");

    private final String description;
}
