/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.payment.api.enums;

import cn.tuia.payment.api.enums.ComplaintRefundStatusEnum;
import com.google.common.base.Objects;

public enum RefundStatusEnum {
    REFUND_IN_DB_WX(58, "", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u9000\u6b3e\u5165\u5e93\u4e86"),
    REFUND_IN_DB(59, "", "\u9000\u6b3e\u5165\u5e93\u4e86"),
    REFUND_SUCCESS(60, "REFUND_SUCCESS", "\u9000\u8d39\u6210\u529f"),
    REFUND_FAIL(70, "REFUND_FAIL", "\u60a8\u7684\u8ba2\u5355\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u5ba2\u670d\u8fdb\u884c\u9000\u6b3e"),
    REFUND_WILL_BE_PROCESS_TILL_1230(79, "", "\u60a8\u7684\u9000\u6b3e\u8ba2\u5355\u5df2\u63d0\u4ea4\uff0c\u8bf7\u5173\u6ce8\u8d26\u6237\u4f59\u989d"),
    REFUND_PROCESS(80, "REFUND_PROCESSING", "\u9000\u8d39\u5904\u7406\u4e2d"),
    REFUND_UNKNOWN(90, "", "\u9000\u8d39\u7ed3\u679c\u4e0d\u660e"),
    REFUND_WAIT_AUDIT(100, "", "\u7b49\u5f85\u4eba\u5de5\u5ba1\u6838"),
    MER_PROCESS(110, "", "\u60a8\u7684\u8ba2\u5355\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u4eba\u5de5\u5ba2\u670d\u8fdb\u884c\u9000\u6b3e");

    private final Integer code;
    private final String fubeiCode;
    private final String msg;

    public static Integer liandongTrans2code(String status) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (!value.name().equalsIgnoreCase(status)) continue;
            return value.getCode();
        }
        return REFUND_PROCESS.getCode();
    }

    public static Integer fubeiTrans2code(String status) {
        for (RefundStatusEnum value : RefundStatusEnum.values()) {
            if (!value.getFubeiCode().equalsIgnoreCase(status)) continue;
            return value.getCode();
        }
        return REFUND_PROCESS.getCode();
    }

    public static Integer transComplainRefundStatus(Integer status) {
        if (Objects.equal((Object)status, (Object)REFUND_IN_DB_WX.getCode()) || Objects.equal((Object)status, (Object)REFUND_IN_DB.getCode())) {
            return ComplaintRefundStatusEnum.NO_REFUND.getCode();
        }
        if (Objects.equal((Object)status, (Object)REFUND_SUCCESS.getCode())) {
            return ComplaintRefundStatusEnum.SUCCESS.getCode();
        }
        if (Objects.equal((Object)status, (Object)REFUND_PROCESS.getCode()) || Objects.equal((Object)status, (Object)REFUND_WAIT_AUDIT.getCode())) {
            return ComplaintRefundStatusEnum.ING.getCode();
        }
        return ComplaintRefundStatusEnum.FAIL.getCode();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getFubeiCode() {
        return this.fubeiCode;
    }

    public String getMsg() {
        return this.msg;
    }

    private RefundStatusEnum(Integer code, String fubeiCode, String msg) {
        this.code = code;
        this.fubeiCode = fubeiCode;
        this.msg = msg;
    }
}

