package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: ComplaintRefundStatusEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.07 11:53
 */
@Getter
@AllArgsConstructor
public enum ComplaintRefundStatusEnum {

    NO_REFUND(0, "未退款"),
    SUCCESS(1, "退款成功"),
    ING(2, "退款中"),
    FAIL(3, "退款失败"),
    ;

    private final Integer code;
    private final String desc;

    public static String getDesc(Integer code) {
        for (ComplaintRefundStatusEnum value : ComplaintRefundStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value.getDesc();
            }
        }
        return null;
    }
}
