package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: CustomerComplaintEntity
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.06 13:44
 */
@Getter
@Setter
@TableName("tb_customer_complaint")
public class CustomerComplaintEntity implements Serializable {

    private static final long serialVersionUID = -1121854954035978084L;
    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 渠道
     */
    @TableField("channel")
    private Integer channel;

    /**
     * 通知id
     */
    @TableField("notify_id")
    private String notifyId;

    /**
     * 投诉id
     */
    @TableField("complain_id")
    private Long complainId;

    /**
     * 投诉单号
     */
    @TableField("complain_no")
    private String complainNo;

    /**
     * 交易流水号
     */
    @TableField("bank_order_no")
    private String bankOrderNo;

    /**
     * 商家订单号
     */
    @TableField("mer_order_no")
    private String merOrderNo;

    /**
     * 交易时间
     */
    @TableField("gmt_trade")
    private Date gmtTrade;

    /**
     * 投诉时间
     */
    @TableField("gmt_complain")
    private Date gmtComplain;

    /**
     * 投诉内容
     */
    @TableField("complain_content")
    private String complainContent;

    /**
     * 交易单号
     * 这里应该是 trade_no 而不是 compain_content，根据字段名进行修正。
     */
    @TableField("trade_no")
    private String tradeNo;

    /**
     * 状态码
     */
    @TableField("status")
    private String status;

    /**
     * 推送时间
     */
    @TableField("gmt_risk_finish_time")
    private Date gmtRiskFinishTime;

    /**
     * 投诉金额
     */
    @TableField("complain_amount")
    private String complainAmount;

    /**
     * 联系方式
     */
    @TableField("contact")
    private String contact;


    /**
     * 退款金额
     */
    @TableField("refund_amount")
    private Long refundAmount;

    /**
     * 退款状态
     */
    @TableField("refund_status")
    private Integer refundStatus;

    /**
     * 退款时间
     */
    @TableField("gmt_refund")
    private Date gmtRefund;
}
