package cn.tuia.payment.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.req.up.UpBankMerQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.dto.up.UpBankMerDTO;
import cn.tuia.payment.api.entity.UpBankMerEntity;

import java.util.List;
import java.util.Set;

/**
 * @author lizhiheng
 */
@AdvancedFeignClient
public interface RemoteUpBankMerService {
    /**
     * 根据商户号 获取 商户信息
     *
     * @param mid
     * @return
     */
    List<UpBankMerEntity> getByBankMerId(String mid);

    ResultPage<UpBankMerDTO> page(ReqPageQuery<UpBankMerQuery> query);

    List<UpBankMerDTO> list(ReqPageQuery<UpBankMerQuery> query);

    boolean updateOrSaveBankMer(UpBankMerEntity newOne);

    /**
     * 编辑单个
     */
    boolean updateById(UpBankMerEntity bankMer);

    Set<String> membersFromThePool(String merId, Integer timePeriod);
}
