package cn.tuia.payment.api.dto;

import cn.tuia.payment.api.entity.CustomerComplaintEntity;
import cn.tuia.payment.api.entity.PayOrderEntity;
import cn.tuia.payment.api.entity.RefundOrderEntity;
import cn.tuia.payment.api.enums.*;
import cn.tuia.payment.api.utils.AmountUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author y.zhao
 * @title: CompliantDTO
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.07 10:26
 */
@Data
public class CompliantDTO implements Serializable {
    private static final long serialVersionUID = -492835667053444344L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 渠道
     */
    private Integer channel;


    /**
     * 渠道 名称
     */
    private String channelName;

    /**
     * 投诉单号
     */
    private String complainNo;

    /**
     * 支付宝交易单号
     */
    private String bankOrderId;

    /**
     * 商家订单号
     */
    private String merOrderNo;

    /**
     * 订单金额
     */
    private String orderAmount;


    /**
     * 交易时间
     */
    private Date gmtTrade;


    /**
     * 投诉时间
     */
    private Date gmtComplain;

    /**
     * 投诉单状态
     *
     * @see cn.tuia.payment.api.enums.ComplainStatusEnum
     */
    private String complainStatus;

    /**
     * 投诉单状态 描述
     */
    private String complainStatusDesc;

    /**
     * 联系方式
     */
    private String contact;


    /**
     * 投诉内容
     */
    private String complainContent;

    /**
     * 退款金额
     */
    private String refundAmount;

    /**
     * 退款结果
     */
    private Integer refundStatus;

    /**
     * 退款结果 描述
     */
    private String refundStatusDesc;

    /**
     * 退款时间
     */
    private Date gmtRefund;

    /**
     * 支付方式
     */
    private String payWay;

    /**
     * 电话标识 0-未电话 1-已电话
     */
    private Integer telFlag;


    /**
     * 短信表示 0-未短信 1-已短信
     */
    private Integer msgFlag;


    /**
     * 退款标识 0-未退款 1-已退款
     */
    private Integer refundFlag;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 转换
     *
     * @param entity
     * @return
     */
    public static CompliantDTO convert(CustomerComplaintEntity entity, Map<String, PayOrderEntity> orderEntityMap, Map<String, List<RefundOrderEntity>> refundMap) {
        CompliantDTO dto = new CompliantDTO();
        BeanUtils.copyProperties(entity, dto);
        dto.setBankOrderId(entity.getBankOrderNo());
        dto.setChannelName(ComplainChannelEnum.getMsg(entity.getChannel()));
        dto.setComplainStatus(entity.getStatus());
        if (entity.getChannel().equals(PaymentChannelEnum.FU_BEI.getCode())) {
            dto.setComplainStatusDesc(ComplainStatusFubeiEnum.getName(entity.getStatus()));
        } else if (entity.getChannel().equals(PaymentChannelEnum.LIANDONG_V2.getCode())) {
            dto.setComplainStatusDesc(ComplainStatusLiandongWxEnum.getCommonComplaintStatus(entity.getStatus()));
        } else {
            dto.setComplainStatusDesc(ComplainStatusEnum.getDesc(entity.getStatus()));
        }
        dto.setRefundAmount(AmountUtil.convertRefundAmountToString(entity.getRefundAmount()));
        dto.setRefundStatus(entity.getRefundStatus());
        dto.setRefundStatusDesc(ComplaintRefundStatusEnum.getDesc(dto.getRefundStatus()));
        if (Objects.nonNull(orderEntityMap)) {
            PayOrderEntity payOrderEntity = orderEntityMap.get(entity.getBankOrderNo());
            if (Objects.nonNull(payOrderEntity)) {
                dto.setRefundStatus(payOrderEntity.getRefundStatus());
                dto.setRefundStatusDesc(OrderRefundStatusEnum.getDescByCode(payOrderEntity.getRefundStatus()));
                dto.setGmtRefund(payOrderEntity.getGmtModified());
                dto.setPhone(payOrderEntity.getPhone());
                if (Objects.nonNull(refundMap) && refundMap.containsKey(payOrderEntity.getBankOrderId())) {
                    List<RefundOrderEntity> refundOrderEntityList = refundMap.get(payOrderEntity.getBankOrderId());
                    if (CollectionUtils.isNotEmpty(refundOrderEntityList)) {
                        Long reduce = refundOrderEntityList.stream().map(RefundOrderEntity::getRefundAmount)
                                .reduce(0L, Long::sum);
                        dto.setRefundAmount(AmountUtil.convertRefundAmountToString(reduce));
                        dto.setGmtRefund(refundOrderEntityList.get(0).getRefundTime());
                    }
                }
            }
        }
        if (StringUtils.isNotEmpty(entity.getPayWay())) {
            boolean contains = Objects.nonNull(entity.getPayWay()) && TuiaPayWayEnum.ALI_PAY.contains(Integer.valueOf(entity.getPayWay()));
            if (contains) {
                dto.setPayWay(TuiaPayWayEnum.ALIPAY.getName());
            } else {
                dto.setPayWay(TuiaPayWayEnum.WECHAT_PAY.getName());
            }
        } else {
            dto.setPayWay(TuiaPayWayEnum.ALIPAY.getName());
        }
        return dto;
    }
}
