package cn.tuia.payment.api.dto.req;

import cn.tuia.payment.api.dto.*;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author y.zhao
 * @title: BankMerPoolCreateReq
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.09.02 14:03
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BankMerPoolCreateReq extends MerBankPoolConfigDTO implements Serializable {
    private static final long serialVersionUID = 5364877508426148920L;

    /**
     * 主键id
     */
    private Long id;

    private Integer channel;

    private String type;

    private String name;

    private String remark;

    /**
     * 投放策略
     *
     * @see cn.tuia.payment.api.enums.MerPoolStrategyEnum
     */
    private Integer releasingStrategy;

    /**
     * 关联信息
     */
    private String relation;
}
