package cn.tuia.payment.api.entity;

import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * @author y.zhao
 * @title: ComplainMsgPushEntity
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.06 13:50
 */

@Getter
@Setter
@TableName("tb_complain_msg_push")
public class ComplainMsgPushEntity implements Serializable {

    private static final long serialVersionUID = 2193995234172194790L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 更新时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 关联 tb_customer_complaint 主键id
     */
    @TableField("complain_id")
    private Long complainId;

    /**
     * 请求参数
     */
    @TableField("request")
    private String request;

    /**
     * 返回参数
     */
    @TableField("response")
    private String response;

    /**
     * 投诉处理是否成功
     */
    @TableField("complain_process_success")
    private Integer complainProcessSuccess;


    /**
     * 推送次数
     */
    @TableField("push_num")
    private Integer pushNum;
}
