package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
@TableName("tb_pay_order_v2_info")
public class PayOrderV2InfoEntity implements Serializable {
    private static final long serialVersionUID = -4048727235297385204L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    @TableField(value = "order_id")
    private String orderId;
    /**
     * 上报subtype
     */
    @TableField("sub_type")
    private Integer subType;

    /**
     * 是否上报，0 没上报 1 上报
     */
    @TableField("callback")
    private Integer callback;

    /**
     * 上报类型，1，概率 2，手动
     */
    @TableField("callback_type")
    private Integer callbackType;

    /**
     * 广告id
     */
    @TableField("ad_id")
    private Long adId;

    /**
     * 广告name
     */
    @TableField("ad_name")
    private String adName;

    /**
     * 广告主id
     */
    @TableField("advertiser_id")
    private Long advertiserId;

    /**
     * 广告主名称
     */
    @TableField("advertiser_name")
    private String advertiserName;

    /**
     * 媒体id
     */
    @TableField("media_id")
    private Long mediaId;

    /**
     * 广告位id
     */
    @TableField("slot_id")
    private Long slotId;
}