package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 手机号短信发送记录
 */
@Data
@TableName("tb_phone_sms_record")
public class PhoneSmsRecordEntity implements Serializable {

    private static final long serialVersionUID = 5341894344743313466L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;

    /**
     * tuia_id
     */
    @TableField("tuia_id")
    private String tuiaId;

    /**
     * 短信签名id
     */
    @TableField("sign_id")
    private Long signId;
    /**
     * 短信模板id
     */
    @TableField("template_id")
    private Long templateId;

    /**
     * 积木id
     */
    @TableField("jimu_id")
    private String jimuId;

    /**
     * 调用接口结结果
     */
    @TableField("result")
    private boolean result;

    /**
     * 短信发送内容
     */
    @TableField("content")
    private String content;


    /**
     * 发送结果
     */
    @TableField("result_msg")
    private String resultMsg;

    /**
     * 记录创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;


}
