package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.github.jeffreyning.mybatisplus.anno.MppMultiId;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@TableName("tb_settle_confirm_and_split")
public class SettleConfirmAndSplitEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @TableField("gmt_create")
    private Date gmtCreate;

    @TableField("gmt_modified")
    private Date gmtModified;

    @TableField("order_id")
    private String orderId;

    @TableField("bank_order_id")
    @MppMultiId
    private String bankOrderId;

    @TableField("settle_id")
    private String settleId;

    @TableField("settle_status")
    private String settleStatus;

    @TableField("settle_amount")
    private Long settleAmount;

    @TableField("settle_params")
    private String settleParams;

    @TableField("settle_result")
    private String settleResult;

    @TableField("pay_amount")
    private Long payAmount;

    @TableField("split_id")
    private String splitId;

    @TableField("split_trans_in")
    private String splitTransIn;

    @TableField("split_status")
    private String splitStatus;

    @TableField("split_amount")
    private Long splitAmount;

    @TableField("split_params")
    private String splitParams;

    @TableField("split_result")
    private String splitResult;
}