package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author y.zhao
 * @title: ActOrderStatusEnum
 * @projectName tuia-payment
 * @description: description
 * @date 2024.07.02 16:59
 */
@Getter
@AllArgsConstructor
public enum ActOrderStatusEnum {

    INITIAL(0, "初始值"),
    UN_PAY(10, "待支付"),
    PAYING(11, "支付中"),
    PAID(20, "已支付"),
    CASHING(21, "提现中"),
    UN_PAID(22, "未支付"),// 用于已经支付的订单，更新状态时却发现支付单未支付
    PAYED_TO_TRANS(23, "支付了，但是有转账信息"),// 用于已经支付的订单，已经支付，却有转账信息
    PAYED_TO_REFUND(24, "支付了，但是有退款信息"),// 用于已经支付的订单，已经支付，却有退款信息
    CASH_FAILED(29, "提现失败"),
    CASHED(30, "已提现"),
    REFUND_ING(32, "退款中"),
    REFUND_FAIL(35, "退款失败"),
    REFUNDED(40, "已退款"),
    ;

    private final Integer code;
    private final String msg;

    /**
     * 转换成前端的枚举
     */
    public static Integer convertVOStatus(Integer code) {
        if (code >= REFUND_ING.getCode()) {
            return code;
        } else if (code >= CASHED.getCode()) {
            return CASHED.getCode();
        } else if (code >= PAID.getCode()) {
            return PAID.getCode();
        }else if (code >= UN_PAY.getCode()) {
            return UN_PAY.getCode();
        }  else {
            return code;
        }
    }

    /**
     * 是否已经完成
     * 目前判断是 已经 提现 或者 已经退款
     * >= 30
     */
    public static boolean isFinished(Integer status) {
        return !Objects.isNull(status) && (status.equals(CASHED.getCode()) || status.equals(REFUNDED.getCode()));
    }

    /**
     * 是否 未支付
     */
    public static boolean isUnPay(Integer status) {
        return !Objects.isNull(status) && status < PAID.getCode();
    }

    /**
     * 是否已开始提现
     */
    public static boolean isTrans(Integer status) {
        return !Objects.isNull(status) && status >= CASHED.getCode();
    }
}
