package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: ComplaintResolutionStatus
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.06 14:52
 */
@Getter
@AllArgsConstructor
public enum ComplainProcessEnum {
    /**
     * 已联系到用户，协商一致，无异议
     */
    CONSENSUS_WITH_CLIENT("已联系到用户，协商一致，无异议"),

    /**
     * 其他
     */
    ORTHER("其他"),

    /**
     * 不涉及退款，已针对投诉内容进行整改
     */
    RECTIFICATION_NO_REFUND("不涉及退款，已针对投诉内容进行整改"),

    /**
     * 已退款，用户无异议
     */
    REFUND("已退款，用户无异议"),

    /**
     * 已提交证明材料，但尚未联系到用户
     */
    SUBMIT_PROOF_NOT_CONTACTED("已提交证明材料，但尚未联系到用户");

    private final String description;
}
