package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 产品模板枚举
 */
@Getter
@AllArgsConstructor
public enum ProductTemplateEnum {

    TWELVE_PHASE(1, "12期模板"),

    ZERO_PLUS_TWELVE(2, "0+12期模板"),

    ;

    private final Integer code;
    private final String desc;

    public static String getDescByCode(Integer code) {
        for (ProductTemplateEnum e : ProductTemplateEnum.values()) {
            if (e.getCode().equals(code)) {
                return e.getDesc();
            }
        }
        return "";
    }

    public static boolean isValid(Integer code) {
        for (ProductTemplateEnum e : ProductTemplateEnum.values()) {
            if (e.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }
}
