package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.PutMerUpdateConfigDTO;
import cn.tuia.payment.api.dto.TimePeriodConfigDTO;
import cn.tuia.payment.api.dto.query.MerTimeConfigQuery;
import cn.tuia.payment.api.dto.req.ReleasingUpdateConfigReq;
import cn.tuia.payment.api.dto.req.TimePeriodConfigReq;
import cn.tuia.payment.api.entity.MerTimeConfigEntity;

import java.util.List;

/**
 * @author y.zhao
 * @title: RemoteMerTimeConfigService
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.21 10:29
 */
@AdvancedFeignClient
public interface RemoteMerTimeConfigService {


    /**
     * 根据 条件查询列表
     *
     * @param query
     * @return
     */
    List<MerTimeConfigEntity> getByQuery(MerTimeConfigQuery query);


    /**
     * 根据渠道 获取对应配置信息
     *
     * @param channel
     * @return
     */
    List<TimePeriodConfigDTO> getConfig(Integer channel);


    /**
     * 保存对应配置信息
     *
     * @param req
     * @return
     */
    Boolean saveConfig(TimePeriodConfigReq req, String adminId);

    /**
     * 查询 子商户号在投池更新配置
     *
     * @param channel
     * @return
     */
    PutMerUpdateConfigDTO getUpdateConfig(Integer channel);


    /**
     * 保存 子商户号在投池更新配置
     *
     * @param req
     * @return
     */
    Boolean saveUpdateConfig(ReleasingUpdateConfigReq req, String adminId);
}
