package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.dto.BankMerDTO;
import cn.tuia.payment.api.dto.PaymentProductDTO;
import cn.tuia.payment.api.dto.req.BankMerQuery;
import cn.tuia.payment.api.dto.req.ReqPageQuery;
import cn.tuia.payment.api.dto.req.query.PaymentProductQuery;
import cn.tuia.payment.api.dto.rsp.ResultPage;
import cn.tuia.payment.api.entity.PaymentProductEntity;

import java.util.List;

/**
 * @author y.zhao
 * @title: RemotePaymentProductService
 * @projectName tuia-payment-center
 * @description: description
 * @date 2025.02.25 18:19
 */
@AdvancedFeignClient
public interface RemotePaymentProductService {

    ResultPage<PaymentProductDTO> page(ReqPageQuery<PaymentProductQuery> query);

    List<PaymentProductDTO> list(PaymentProductQuery query);

    Boolean upsert(PaymentProductDTO dto);

    /**
     * 根据积木id获取产品信息
     * 先根据jimuId获取配置页信息，再根据配置也信息里面的关联产品id获取支付产品详情
     *
     * @param jimuId
     * @return
     */
    PaymentProductDTO getByJimuId(String jimuId);

    /**
     * 根据 订单推啊Id获取产品信息
     * 现根据订单号获取订单信息， 再从订单信息中后去jimuId，再根据jimuId获取配置页信息，再根据配置也信息里面的关联产品id获取支付产品详情
     *
     * @param tuiaId
     * @return
     */
    PaymentProductDTO getByTuiaId(String tuiaId);

    /**
     * 根据手机号 获取产品信息
     * 根据手机查询订单，根据订单获取积木Id，再用积木ID查询产品信息
     *
     * @param phone
     * @return
     */
    PaymentProductDTO getByPhone(String phone);

    /**
     * 根据产品ID获取产品信息
     *
     * @param productId 产品ID
     * @return 产品实体
     */
    PaymentProductEntity getById(Long productId);
}
