package cn.tuia.payment.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.tuia.payment.api.entity.WithholdOrderDetailEntity;
import cn.tuia.payment.api.entity.WithholdOrderRecordEntity;
import cn.tuia.payment.api.entity.WithholdRefundRecordEntity;

import java.math.BigDecimal;
import java.util.List;

/**
 * 代扣订单远程服务
 */
@AdvancedFeignClient
public interface RemoteWithholdOrderService {

    /**
     * 保存代扣订单
     */
    Boolean saveOrder(WithholdOrderRecordEntity entity);

    /**
     * 更新代扣订单
     */
    Boolean updateOrder(WithholdOrderRecordEntity entity);

    /**
     * 根据推啊订单号查询
     */
    WithholdOrderRecordEntity getByTuiaId(String tuiaId);

    /**
     * 保存支付明细
     */
    Boolean saveDetail(WithholdOrderDetailEntity entity);

    /**
     * 更新支付明细
     */
    Boolean updateDetail(WithholdOrderDetailEntity entity);

    /**
     * 根据推啊订单号和期数查询明细
     */
    WithholdOrderDetailEntity getDetailByTuiaIdAndIssueTime(String tuiaId, Integer issueTime);

    /**
     * 根据推啊订单号查询明细列表
     */
    List<WithholdOrderDetailEntity> listDetailByTuiaId(String tuiaId);

    /**
     * 保存退款记录
     */
    Boolean saveRefundRecord(WithholdRefundRecordEntity entity);

    /**
     * 根据退款订单id查询（幂等校验）
     */
    WithholdRefundRecordEntity getRefundByRefundOrderId(String refundOrderId);

    /**
     * 更新订单退款金额和状态
     */
    Boolean updateRefundAmount(String tuiaId, BigDecimal refundAmount, Integer status);
}
