package cn.tuia.payment.api.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author y.zhao
 * @title: LimitConfigDTO
 * @projectName tuia-payment-center
 * @description: description
 * @date 2025.03.25 10:41
 */
@Data
public class GlobalLimitConfigDTO implements Serializable {
    private static final long serialVersionUID = -4003447324510570287L;

    /**
     * 限制类型 1-动态日期限制（订单日期+7）  2-固定时间限制（盘古配置）
     *
     * @see cn.tuia.payment.api.enums.GlobalLimitConfigTypeEnum
     */
    private Integer type;

    /**
     * 时间限制开关
     */
    private Boolean timeLimitFlag;

    /**
     * 限制时间段 8,18
     */
    private String limitTimes;
}
