package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhiheng
 */
@Data
@TableName("tb_bank_mer")
public class BankMerEntity implements Serializable {

    private static final long serialVersionUID = -2781742115576738694L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;

    /**
     * 主商户id，和tb_pay_order表的merchant_no是一个字段
     */
    @TableField("mer_id")
    private String merId;

    /**
     * 子商户id（二级商户id），和tb_pay_order的bank_merchant_no是一个字段
     */
    @TableField("bank_mer_id")
    private String bankMerId;

    /**
     * 分组，联动的分组
     */
    @TableField("liandong_group")
    private String liandongGroup;

    /**
     * 区，比如龙海市
     */
    @TableField("distinct_code")
    private String distinctCode;

    /**
     * 城市，比如漳州市
     */
    @TableField("city_code")
    private String cityCode;

    /**
     * 省市，比如福建省
     */
    @TableField("province_code")
    private String provinceCode;

    /**
     * 使用时段，运营维护，一天分为4个时段，1，2，3，4
     */
    @TableField("time_period")
    private Integer timePeriod;


    /**
     * 联动同步过来的状态，启用、关闭、禁用
     */
    @TableField("liandong_status")
    private Integer liandongStatus;

    /**
     * 人工操作的状态，启用、关闭、禁用
     */
    @TableField("tuia_status")
    private Integer tuiaStatus;

    /**
     * 投放状态，待投、在投、下线、未知
     */
    @TableField("release_status")
    private Integer releaseStatus;

    /**
     * 投放状态更新时间
     */
    @TableField("release_modified_time")
    private Date releaseModifiedTime;

    /**
     * 使用时段更新时间
     */
    @TableField("period_modified_time")
    private Date periodModifiedTime;

    /**
     * 最近编辑人
     */
    @TableField("last_admin_id")
    private String lastAdminId;

    /**
     * 支付渠道，1.联动，2.自研微信小程序，3付呗，还有其他的看枚举值
     */
    @TableField("payment_channel")
    private String paymentChannel;

    /**
     * 待投巡检开关0-关 1-开
     */
    @TableField("on_off")
    private Integer onOff;


    /**
     * 待投巡检开启时间
     */
    @TableField("on_time")
    private Date onTime;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;


    /**
     * 商户池id
     */
    @TableField("pool_id")
    private Long poolId;


    /**
     * 主体
     */
    @TableField("main_body")
    private String mainBody;


    /**
     * 投放开始时间
     */
    @TableField("gmt_releasing")
    private Date gmtReleasing;
}