package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
@TableName("tb_limit_config")
public class LimitConfigEntity implements Serializable {

    private static final long serialVersionUID = -5639836920671121928L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @TableField(value = "gmt_modified", update = "CURRENT_TIMESTAMP")
    private Date gmtModified;

    /**
     * 渠道
     */
    private Integer channel;

    /**
     * 行业
     */
    private String type;

    /**
     * 限额类型，主体，地域，等
     */
    @TableField("limit_type")
    private Integer limitType;

    /**
     * 实际限额内容
     */
    @TableField("limit_content")
    private String limitContent;

    /**
     * 限额时间周期
     */
    @TableField("time_scope")
    private Integer timeScope;

    /**
     * 限额上限
     */
    @TableField("upper_limit")
    private Integer upperLimit;

    /**
     * 最近编辑人
     */
    @TableField("last_admin_id")
    private String lastAdminId;

    /**
     * 最近编辑时间
     */
    @TableField("last_edit_time")
    private Date lastEditTime;

    /**
     * 开启，关闭
     */
    @TableField("on_off")
    private Boolean onOff;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否删除，1是 0否
     */
    @TableField("is_delete")
    private Boolean isDelete;
}