package cn.tuia.payment.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author assistant
 */
@Data
@TableName("tb_probability_report_config")
public class ProbabilityReportConfigEntity implements Serializable {
    private static final long serialVersionUID = 7996328070987502086L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 概率上报主表id
     */
    @TableField("config_page_id")
    private Long configPageId;

    /**
     * 广告位id
     */
    @TableField("slot_id")
    private Long slotId;

    /**
     * 回传节点
     */
    @TableField("sub_type")
    private String subType;

    /**
     * 回传概率
     */
    @TableField("return_probability")
    private String returnProbability;

    /**
     * 配置类型
     */
    @TableField("config_type")
    private String configType;

    /**
     * 记录创建时间
     */
    @TableField("gmt_create")
    private Date gmtCreate;

    /**
     * 记录更新时间
     */
    @TableField(value = "gmt_modified", update = "now()")
    private Date gmtModified;
} 