package cn.tuia.payment.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author y.zhao
 * @title: ComplaintTradeStatusEnum
 * @projectName tuia-payment-center
 * @description: description
 * @date 2024.08.06 15:04
 */
@Getter
@AllArgsConstructor
public enum ComplaintTradeStatusEnum {
    /**
     * 用户撤诉
     */
    DROP_COMPLAIN("用户撤诉"),

    /**
     * 超时未处理
     */
    OVERDUE("超时未处理"),

    /**
     * 已退款
     */
    PROCESSED("已退款"),

    /**
     * 退款处理中
     */
    REFUNDING("退款处理中"),

    /**
     * 待处理
     */
    WAIT_PROCESS("待处理");

    private final String description;
}
